/*
 *	(c) Willem van Schaik - CommaSeparatedFile -> AddressBookArchive (Palm)
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "palmaba.h"

/* global variables */

FILE *fpCsv;
FILE *fpAba;

/* subroutines */

void aba_char (unsigned char chr)
{
	fputc (chr, fpAba);

	return;
}

void aba_shrt (unsigned long val)
{
	fputc (val >>  0 & 0xFF, fpAba);
	fputc (val >>  8 & 0xFF, fpAba);

	return;
}

void aba_long (unsigned long val)
{
	fputc (val >>  0 & 0xFF, fpAba);
	fputc (val >>  8 & 0xFF, fpAba);
	fputc (val >> 16 & 0xFF, fpAba);
	fputc (val >> 24 & 0xFF, fpAba);

	return;
}

void aba_cstr (char * str)
{
	int i;

	if (strlen(str) == 0)
		fputc (0, fpAba);
	else if (strlen(str) < 255)
	{
		fputc ((char) strlen(str), fpAba);
		for (i=0; i<(int)strlen(str); i++)
			fputc (str[i], fpAba);
	}
	else
	{
		fputc (0xFF, fpAba);
		fputc ((char) (strlen(str) & 0xFF), fpAba);
		fputc ((char) ((strlen(str) >> 8) & 0xFF), fpAba);
		for (i=0; i<(int)strlen(str); i++)
			fputc (str[i], fpAba);
	}
	return;
}

void anal_header (char rec[1024], int cols[21])
{
	char	*p, *q, *s;
	char	szCol[32];
	int		inStr = 0;
	int		i;

	/* init cols */
	for (i = 0; i <= 20; i++)
		cols[i] = 0;

	i = 1;
	p = &rec[0];
	q = &rec[0] + strlen (rec);
	while (p < q)
	{
		/* extract a column header */
		if (*p == '"')
		{
			inStr = 1;
			p++;
		}
		s = &szCol[0];
		while ((*p != ((inStr) ? '"' : ',')) && (p < q))
		{
			*s++ = *p++;
		}
		*s = '\0';
		p++;
		if (inStr)
		{
			inStr = 0;
			p++;
		}

		/* analyze the column header */
		if (strcmp (szCol, "name") == 0)
			cols[NAME] = i;
		else if (strcmp (szCol, "first") == 0)
			cols[FIRST] = i;
		else if (strcmp (szCol, "title") == 0)
			cols[TITLE] = i;
		else if (strcmp (szCol, "company") == 0)
			cols[COMPANY] = i;
		else if (strcmp (szCol, "phone1") == 0)
			cols[PHONE1] = i;
		else if (strcmp (szCol, "phone2") == 0)
			cols[PHONE2] = i;
		else if (strcmp (szCol, "phone3") == 0)
			cols[PHONE3] = i;
		else if (strcmp (szCol, "phone4") == 0)
			cols[PHONE4] = i;
		else if (strcmp (szCol, "phone5") == 0)
			cols[PHONE5] = i;
		else if (strcmp (szCol, "address") == 0)
			cols[ADDRESS] = i;
		else if (strcmp (szCol, "city") == 0)
			cols[CITY] = i;
		else if (strcmp (szCol, "state") == 0)
			cols[STATE] = i;
		else if (strcmp (szCol, "zip") == 0)
			cols[ZIP] = i;
		else if (strcmp (szCol, "country") == 0)
			cols[COUNTRY] = i;
		else if (strcmp (szCol, "note") == 0)
			cols[NOTE] = i;
		else if (strcmp (szCol, "private") == 0)
			cols[PRIVATE] = i;
		else if (strcmp (szCol, "custom1") == 0)
			cols[CUSTOM1] = i;
		else if (strcmp (szCol, "custom2") == 0)
			cols[CUSTOM2] = i;
		else if (strcmp (szCol, "custom3") == 0)
			cols[CUSTOM3] = i;
		else if (strcmp (szCol, "custom4") == 0)
			cols[CUSTOM4] = i;

		i++;		
	}

	return;
}

void anal_record (char rec[1024], int cols[21], char flds[21][256])
{
	char	*p, *q, *s;
	int		inStr = 0;
	int		i;

	i = 1;
	p = &rec[0];
	q = &rec[0] + strlen (rec);
	while (p < q)
	{
		/* extract a field */
		if (*p == '"')
		{
			inStr = 1;
			p++;
		}
		s = &flds[i][0];
		while ((*p != ((inStr) ? '"' : ',')) && (p < q))
		{
			*s++ = *p++;
		}
		*s = '\0';
		p++;
		if (inStr)
		{
			inStr = 0;
			p++;
		}
		/* strip trailing/leading blanks */
		while (flds[i][strlen(flds[i]) - 1] == ' ')
			flds[i][strlen(flds[i]) - 1] = '\0';
		while (flds[i][0] == ' ')
			strcpy (&flds[i][0], &flds[i][1]);
		i++;		
	}
	return;
}

int main( int argc, char **argv )
{
	char	fileCsv[256], fileAba[256];
	char	rec[1024];
	char	buf[1024];
	int		cols[21];
	char	flds[21][256];
	int		header = 0;
	int		cat = 0;
	char	category[255];
	int	i, n;

	/* check flags */
	n = 1;
	while ((n < argc) && (argv[n][0] == '-'))
	{
		if (argv[n][1] == 'h')
		{
			header = 1;
			n++;
		}
		else if (argv[n][1] == 'c')
		{
			cat = 1;
			n++;
			strcpy (category, argv[n]);
			n++;
		}
	}

	/* get files */
	if (n > (argc - 2))
	{
		printf ("usage: palmaba [-h] [-c category] <infile> <outfile>\n");
		exit(1);
	}
	strcpy (fileCsv, argv[n++]);
	strcpy (fileAba, argv[n++]);

	/* open files */
	if ((fpCsv = fopen (fileCsv, "r")) == NULL)
	{
		printf ("palmaba: can't open input file %s\n", fileCsv);
		exit(1);
	}
	if ((fpAba = fopen (fileAba, "wb")) == NULL)
	{
		printf ("palmaba: can't open output file %s\n", fileAba);
		exit(1);
	}

	/* init cols */
	for (i=0; i<=20; i++)
		cols[i] = i;

	/* first record */
	if (header)
	{
		if ((fgets (rec, 1023, fpCsv)) == NULL)
		{
			printf ("palmaba: empty in-file\n");
			exit(1);
		}
		anal_header(rec, cols);
	}

	/* print version tag */
	aba_char (0x00);
	aba_char (0x01);
	aba_char (0x42);
	aba_char (0x41);
		
	/* print file name */
	aba_cstr ("C:\\PalmAddress.aba");
		
	/* print table string */
	sprintf (buf, "%s%c%s%c%s%c%s%c%s%c%s%c%c%c%c%s%c%c", 
			"Custom 1", 0x0A, "Custom 2", 0x0A, "Custom 3", 0x0A, "Custom 4", 0x0A, 
			"01234", 0x0A, "1", 0x0A, 0x0A, 0x0A, 0x0A, "1", 0x0A, 0x0A);
	aba_cstr (buf);
		
	/* print next free */
	aba_long (0x81); /* ??????? */

	/* print category count */
	aba_long (1);

	/* print the categories */

	/* index */
	aba_long (1);
	/* id */
	aba_long (1);
	/* dirty flag */
	aba_long (0);
	/* category */
	if (cat)
	{
		/* long name */
		aba_cstr (category);
		/* short name */
		category[8] = '\0';
		aba_cstr (category);
	}
	else
	{
		/* long name */
		aba_cstr ("Unfiled");
		/* short name */
		aba_cstr ("Unfiled");
	}
	/* resource id */
	aba_long (0x4a);
	/* fields per row */
	aba_long (30);
	/* rec id pos */
	aba_long (0);
	/* rec status pos */
	aba_long (1);
	/* placement pos */
	aba_long (2);
	/* field count */
	aba_shrt (30);

	/* field entry */
	aba_shrt (1);
	aba_shrt (1);
	aba_shrt (1);
	aba_shrt (5);
	aba_shrt (5);
	aba_shrt (5);
	aba_shrt (5);
	aba_shrt (1);
	aba_shrt (5);
	aba_shrt (1);

	aba_shrt (5);
	aba_shrt (1);
	aba_shrt (5);
	aba_shrt (1);
	aba_shrt (5);
	aba_shrt (1);
	aba_shrt (5);
	aba_shrt (5);
	aba_shrt (5);
	aba_shrt (5);

	aba_shrt (5);
	aba_shrt (5);
	aba_shrt (5);
	aba_shrt (6);
	aba_shrt (1);
	aba_shrt (5);
	aba_shrt (5);
	aba_shrt (5);
	aba_shrt (5);
	aba_shrt (1);

	/* count entries */
	n = 0;
	while (fgets (rec, 1023, fpCsv) != NULL)
		n++;
	fclose (fpCsv);
	fpCsv = fopen (fileCsv, "r");
	if (header)
		fgets (rec, 1023, fpCsv); /* skip header */

	/* print number of address entries (fields) */
	aba_long (n * 30);

	/* initialize record ID */	
	n = 1;

	/* for each address entry print out name + all attrs and values */
	while (fgets (rec, 1023, fpCsv) != NULL)
	{
		/* initialize record fields */
		for (i=0; i<=20; i++)
			strcpy (flds[i], "");

		/* process record */
		if (rec [strlen (rec) - 1] == '\n')
			rec [strlen (rec) - 1] = '\0';
		anal_record( rec, cols, flds );

		/* print field type */
		aba_long (1);
		/* print record id */
		aba_long (n++);
		
		/* print field type */
		aba_long (1);
		/* print status field */
		aba_long (0);
		
		/* print field type */
		aba_long (1);
		/* print position */
		aba_char (0xFF);
		aba_char (0xFF);
		aba_char (0xFF);
		aba_char (0x7F);
		
		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print last name */
		aba_cstr( flds[cols[NAME]] );

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print first name */
		aba_cstr( flds[cols[FIRST]] );

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print title */
		aba_cstr( flds[cols[TITLE]] );

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print company */
		aba_cstr( flds[cols[COMPANY]] );

		/* print field type */
		aba_long (1);
		/* print phone label id */
		aba_long (0);

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print phone 1 */
		aba_cstr( flds[cols[PHONE1]] );

		/* print field type */
		aba_long (1);
		/* print phone label id */
		aba_long (1);

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print phone 2 */
		aba_cstr( flds[cols[PHONE2]] );

		/* print field type */
		aba_long (1);
		/* print phone label id */
		aba_long (2);

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print phone 3 */
		aba_cstr( flds[cols[PHONE3]] );

		/* print field type */
		aba_long (1);
		/* print phone label id */
		aba_long (3);

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print phone 4 */
		aba_cstr( flds[cols[PHONE4]] );

		/* print field type */
		aba_long (1);
		/* print phone label id */
		aba_long (4);

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print phone 5 */
		aba_cstr( flds[cols[PHONE5]] );

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print address - building */
		aba_cstr( flds[cols[ADDRESS]] );

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print city */
		aba_cstr( flds[cols[CITY]] );

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print state */
		aba_cstr( flds[cols[STATE]] );

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print zip */
		aba_cstr( flds[cols[ZIP]] );

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print country */
		aba_cstr( flds[cols[COUNTRY]] );

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print note */
		aba_cstr( flds[cols[NOTE]] );

		/* print field type */
		aba_long (6);
		/* print private */
		if ((flds[cols[PRIVATE]][0] == '1') ||
		    (flds[cols[PRIVATE]][0] == 't') ||
		    (flds[cols[PRIVATE]][0] == 'T'))
			aba_long (1);
		else
			aba_long (0);

		/* print field type */
		aba_long (1);
		/* print category */
		aba_long (1); /* !!!!!!!!!! */

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print custom 1 */
		aba_cstr( flds[cols[CUSTOM1]] );

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print custom 2 */
		aba_cstr( flds[cols[CUSTOM2]] );

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print custom 3 */
		aba_cstr( flds[cols[CUSTOM3]] );

		/* print field type */
		aba_long (5);
		/* print padding */
		aba_long (0);
		/* print custom 4 */
		aba_cstr( flds[cols[CUSTOM4]] );

		/* print field type */
		aba_long (1);
		/* print display phone */
		aba_long (1);

	}

	/* cleanup */

	fclose (fpCsv);
	fclose (fpAba);

	return( 0 );
}
